from pydantic import BaseModel, Field
from typing import Optional, Dict, Any, Literal, List
from datetime import datetime
from bson import ObjectId

class GeofenceCondition(BaseModel):
    parameter: str
    operator: str
    value: Any
    
class GeofenceRuleBase(BaseModel):
    account_id: str
    user_id: Optional[str] = None
    rule_name: str
    conditions: List[GeofenceCondition]  # ✅ now expects list
    action: str  # e.g., "send_alert", "dispatch_extra_unit"
    action_message: Optional[str] = None  # ✅ rename this to match payload
    alert_message: Optional[str] = None  # ✅ rename this to match payload
    trigger_events: Literal["enter", "exit", "dwell"]

class GeofenceRuleCreate(GeofenceRuleBase):
    pass

class GeofenceRuleUpdate(BaseModel):
    rule_name: Optional[str] = None
    conditions: Optional[Dict[str, Any]] = None
    action: Optional[str] = None
    action_message: Optional[str] = None
    alert_message: Optional[str] = None
    trigger_events: Optional[Literal["enter", "exit", "dwell"]] = None

class GeofenceRule(GeofenceRuleBase):
    id: Optional[str] = None
    created_date: datetime = Field(default_factory=datetime.utcnow)

    class Config:
        json_encoders = {ObjectId: str}

class GeofenceRulesList(BaseModel):
    total_count: int
    users: List[GeofenceRule]
